<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Configuración de la base de datos
require 'config/db.php'; // Esto ya te conecta a la base de datos y guarda la conexión en $conn


// Obtener el ID del usuario logueado y el ID de la federación desde la sesión
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];


// Usamos la variable $conn para las consultas
$datos = null;
$show_popup = false;
$modified_data = []; // Array para almacenar los datos modificados
$usuario_registrado = false; // Flag para verificar si el usuario ya está registrado

$stmt_federaciones = $conn->prepare("SELECT id, federacion FROM federaciones WHERE id <> 1");
$stmt_federaciones->execute();
$federaciones = $stmt_federaciones->fetchAll(PDO::FETCH_ASSOC);

$stmt_clubs = $conn->prepare("SELECT club FROM clubs ORDER BY club ASC");
$stmt_clubs->execute();
$clubs = $stmt_clubs->fetchAll(PDO::FETCH_ASSOC);

                
$stmt_opseguro = $conn->prepare("SELECT opseguro FROM opseguro ORDER BY opseguro ASC");
$stmt_opseguro->execute();
$opseguros = $stmt_opseguro->fetchAll(PDO::FETCH_COLUMN);



$stmt_anios = $conn->prepare("SELECT * FROM anios");
$stmt_anios->execute();
$anios = $stmt_anios->fetch(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar si el documento ya existe en la base de datos
    $documento = $_POST['documento'];
    $stmt = $conn->prepare("SELECT COUNT(*) FROM users WHERE documento = :documento");
    $stmt->execute([':documento' => $documento]);
    $count = $stmt->fetchColumn();
    $fechanac = $_POST['fechanac'];
    $fecha_formateada = date("d/m/Y", strtotime($fechanac)); // Convierte yyyy-mm-dd a dd/mm/yyyy
    $categoria0 = $_POST['categoria0'];
    $categoria1 = isset($_POST['categoria1']) && !empty($_POST['categoria1']) ? $_POST['categoria1'] : null;
    $categoriaConcatenada = $categoria1 ? $categoria0 . ' - ' . $categoria1 : $categoria0;
    $fecha_registro = date("Y-m-d H:i:s");



    $documento = $_POST['documento'] ?? '';
    $foto_path = '../fotos/' . $documento . '.png';

    // Verificar si la foto existe
    $foto_existe = file_exists($foto_path);
    if($foto_existe) {
        // Si la foto existe, mostrarla
        $foto = $foto_path;
    } else {
        // Si no existe, mostrar una imagen por defecto
        $foto = '../fotos/default.png';
    }

if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
    // Obtener información del archivo subido
    $fileTmpPath = $_FILES['foto']['tmp_name'];
    $fileName = $_FILES['foto']['name'];
    $fileSize = $_FILES['foto']['size'];
    $fileType = $_FILES['foto']['type'];
    $fileNameCmps = explode(".", $fileName);
    $fileExtension = strtolower(end($fileNameCmps));

    // Asegúrate de que la variable $documento esté definida
    if (!isset($documento)) {
        echo "La variable \$documento no está definida.";
        exit;
    }

    // Establecer el nombre del archivo como documento.png
    $newFileName = $documento . '.png';

    // Establecer la ruta de destino
    $uploadFileDir = '../fotos/';
    $dest_path = $uploadFileDir . $newFileName;

    // Crear una imagen según el tipo de archivo
    switch ($fileExtension) {
        case 'jpg':
        case 'jpeg':
            $imageResource = imagecreatefromjpeg($fileTmpPath);
            break;
        case 'gif':
            $imageResource = imagecreatefromgif($fileTmpPath);
            break;
        case 'png':
            $imageResource = imagecreatefrompng($fileTmpPath);
            break;
        default:
            echo "Formato de archivo no permitido.";
            exit;
    }

    // Verificar si la creación de la imagen fue exitosa
    if (!$imageResource) {
        echo "Error al crear la imagen desde el archivo.";
        exit;
    }

    // Verificar si la carpeta tiene permisos de escritura
    if (!is_writable($uploadFileDir)) {
        echo "El directorio de destino no tiene permisos de escritura.";
        exit;
    }

    // Guardar la imagen convertida como PNG en el directorio de destino
    if (imagepng($imageResource, $dest_path)) {
        echo "El archivo se ha subido y convertido a PNG correctamente.";
    } else {
        echo "Hubo un error al convertir el archivo a PNG.";
    }

    // Liberar la memoria utilizada por la imagen
    imagedestroy($imageResource);
} else {
    echo "No se ha subido ningún archivo o hubo un error en la carga.";
}


$email = $_POST['email'];
// Preparar la consulta para verificar si el email ya existe y no es del mismo documento
$stmt_email = $conn->prepare("SELECT COUNT(*) FROM users WHERE email = :email AND documento != :documento");
$stmt_email->bindParam(':email', $email, PDO::PARAM_STR);  // Asignar valor al parámetro :email
$stmt_email->bindParam(':documento', $documento, PDO::PARAM_STR);  // Asignar valor al parámetro :documento

// Ejecutar la consulta
$stmt_email->execute();

// Obtener el número de registros que coinciden
$email_exists = $stmt_email->fetchColumn();  // Usamos fetchColumn() para obtener el valor de la primera columna

if ($email_exists > 0) {
    // Si el email ya existe, mostrar un mensaje de error y redirigir
    $_SESSION['error_msg'] = 'El correo electrónico ya está registrado. Por favor, utiliza otro.';
    header('Location: ' . $_SERVER['HTTP_REFERER']);
    exit;
}



    if ($count > 0) {
        // Si el documento ya existe, proceder con la actualización
    
        $sql = "UPDATE users SET 
                uci = :uci, Nombre = :Nombre, apellidos = :apellidos, genero = :genero, vacunado = :vacunado, 
                peso = :peso, altura = :altura, os = :os, fechanac = :fechanac, categoria = :categoria, 
                club = :club, ciudad = :ciudad, calle = :calle, nacionalidad = :nacionalidad, federacion = :federacion, 
                opseguro = :opseguro, telefono = :telefono, email = :email, emergencia = :emergencia, 
                telemergencia = :telemergencia, emailcontacto = :emailcontacto, licenciaanio = :licenciaanio, lic = :lic, licencia = :licencia, fecha_registro = :fecha_registro 
                WHERE documento = :documento";
    } else {
        // Si no existe, realizar la inserción
        $sql = "INSERT INTO users (documento, uci, Nombre, apellidos, genero, vacunado, peso, altura, os, fechanac, 
                categoria, club, ciudad, calle, nacionalidad, opseguro, telefono, email, emergencia, 
                telemergencia, emailcontacto, licenciaanio, lic, fecha_registro) 
                VALUES (:documento, :uci, :Nombre, :apellidos, :genero, :vacunado, :peso, :altura, :os, :fechanac, 
                :categoria, :club, :ciudad, :calle, :nacionalidad, :opseguro, :telefono, :email, :emergencia, 
                :telemergencia, :emailcontacto, :licenciaanio, :lic, :fecha_registro)";
    }
    
    
    // Preparar la consulta
    $stmt = $conn->prepare($sql);

    // Ejecutar la consulta con los datos
    $stmt->execute([
        ':documento' => $_POST['documento'],
        ':uci' => $_POST['uci'],
        ':Nombre' => $_POST['Nombre'],
        ':apellidos' => $_POST['apellidos'],
        ':genero' => $_POST['genero'],
        ':vacunado' => $_POST['vacunado'],
        ':peso' => $_POST['peso'],
        ':altura' => $_POST['altura'],
        ':os' => $_POST['os'],
        ':fechanac' => $fecha_formateada,
        ':categoria' => $categoriaConcatenada,
        ':club' => $_POST['club'],
        ':ciudad' => $_POST['localidad'] . ' - ' . $_POST['provincia'],
        ':calle' => $_POST['calle'],
        ':nacionalidad' => $_POST['nacionalidad'],
        ':opseguro' => $_POST['opseguro'],
        ':telefono' => $_POST['telefono'],
        ':email' => $_POST['email'],
        ':emergencia' => $_POST['emergencia'],
        ':telemergencia' => $_POST['telemergencia'],
        ':licenciaanio' => $_POST['licenciaanio'],
        ':emailcontacto' => $_POST['emailcontacto'],
        ':fecha_registro' => $fecha_registro,
        ':lic' => $_POST['lic'],
        ':licencia' => $_POST['licencia'],
        ':federacion' => $_POST['federacion']

    ]);
        

    
    $labels = [
    'uci' => 'Código UCI',
    'Nombre' => 'Nombre',
    'apellidos' => 'Apellidos',
    'genero' => 'Género',
    'vacunado' => 'Vacunado COVID',
    'peso' => 'Peso',
    'altura' => 'Altura',
    'os' => 'Obra Social',
    'fechanac' => 'Fecha de Nacimiento',
    'categoria' => 'Categoría',
    'club' => 'Club',
    'localidad' => 'Localidad',
    'provincia' => 'Provincia',
    'calle' => 'Calle',
    'nacionalidad' => 'Nacionalidad',
    'opseguro' => 'Opción Seguro',
    'telefono' => 'Teléfono',
    'email' => 'Email',
    'emergencia' => 'Emergencia',
    'telemergencia' => 'Teléfono de Emergencia',
    'emailcontacto' => 'Email de Contacto',
    'licenciaanio' => 'Licencia Año',
];

    // Almacenar los datos modificados para mostrar en el popup
    $modified_data = [
        'uci' => $_POST['uci'],
        'Nombre' => $_POST['Nombre'],
        'apellidos' => $_POST['apellidos'],
        'genero' => $_POST['genero'],
        'vacunado' => $_POST['vacunado'],
        'peso' => $_POST['peso'],
        'altura' => $_POST['altura'],
        'os' => $_POST['os'],
        'fechanac' => $fecha_formateada,
        'categoria' => $categoriaConcatenada,
        'club' => $_POST['club'],
        'localidad' => $_POST['localidad'],
        'provincia' => $_POST['provincia'],
        'calle' => $_POST['calle'],
        'nacionalidad' => $_POST['nacionalidad'],
        'opseguro' => $_POST['opseguro'],
        'telefono' => $_POST['telefono'],
        'email' => $_POST['email'],
        'emergencia' => $_POST['emergencia'],
        'telemergencia' => $_POST['telemergencia'],
        'licenciaanio' => $_POST['licenciaanio'],
        'emailcontacto' => $_POST['emailcontacto'],

    ];

    // Mostrar el popup después de la modificación
    $show_popup = true;
} 



// Acción de recuperar datos según el documento
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['documento'])) {
    // Recuperar el valor de documento
    $documento = trim($_GET['documento']);  // Eliminar espacios innecesarios

    // Recuperar datos desde la base de datos
    $stmt = $conn->prepare("SELECT * FROM users WHERE documento = :documento");
    $stmt->execute([':documento' => $documento]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);




    if ($user) {
        // Verificar si el valor de licenciaanio coincide con la tabla anios
        $stmt_licencia = $conn->prepare("SELECT * FROM anios WHERE licenciaanio = :licenciaanio");
        $stmt_licencia->execute([':licenciaanio' => $user['licenciaanio']]);
        $licencia = $stmt_licencia->fetch(PDO::FETCH_ASSOC);

        if ($licencia) {
            // Si la licencia coincide, mostrar mensaje y no mostrar formulario
            $usuario_registrado = false;
            $datos = $user;  // No se necesitan los datos del usuario si ya está registrado
        } else {
            $datos = $user;
        }
    } else {
        $datos = null;
    }
}


?>