<?php


// Configuración de la base de datos
require 'config/db.php'; // Esto ya te conecta a la base de datos y guarda la conexión en $conn

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}


// Obtener el ID del usuario logueado y el ID de la federación desde la sesión
$usuario_id = $_SESSION["usuario_id"];

$federacion_id_usuario = $_SESSION["usuario_fedid"];
// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];

// Obtener el ID de la carrera desde la URL
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    $_SESSION['error_msg'] = "ID de carrera no válido.";
    header('Location: carreras.php');
    exit();
}

$carrera_id = (int)$_GET['id'];

// Consulta para obtener el nombre de la federación
$sql_carrera = "SELECT * FROM carreras WHERE id = :carrera_id";
$params = [':carrera_id' => $carrera_id];

// Aplicar filtro de federación solo si federacion_id_usuario no es 1
if ($federacion_id_usuario <> 1) {
    $sql_carrera .= " AND federacion_id = :federacion_usuario";
    $params[':federacion_usuario'] = $federacion_id_usuario;
}

$stmt_carrera = $conn->prepare($sql_carrera);
if ($federacion_id_usuario <> 1) {
    $stmt_carrera->bindParam(':carrera_id', $carrera_id, PDO::PARAM_INT);
    $stmt_carrera->execute($params);
} else {
    $stmt_carrera = $conn->prepare("SELECT * FROM carreras WHERE id = :carrera_id");
    $stmt_carrera->bindParam(':carrera_id', $carrera_id, PDO::PARAM_INT);
    $stmt_carrera->execute();
}
$carrera = $stmt_carrera->fetch(PDO::FETCH_ASSOC);

if (!$carrera) {
    $_SESSION['error_msg'] = "Carrera no encontrada o no tienes permiso para editarla.";
    header('Location: carreras.php');
    exit();
}

// Configuración de paginación
$registros_por_pagina = 20;
$pagina_actual = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$inicio_registro = ($pagina_actual - 1) * $registros_por_pagina;

// Obtener las federaciones para el select
$stmt_federaciones = $conn->prepare("SELECT id, federacion FROM federaciones WHERE id <> 1");
$stmt_federaciones->execute();
$federaciones = $stmt_federaciones->fetchAll(PDO::FETCH_ASSOC);

// Consulta para obtener los corredores empadronados en la carrera
$sql_corredores = "SELECT u.documento, u.Nombre, u.apellidos, u.categoria, cr.time, u.uci FROM users u JOIN carreras_registros cr ON u.documento = cr.corredor_documento WHERE cr.carrera_id = :carrera_id and u.lic = 'Activa' ";
// Ejecutar consulta con paginación
$stmt_corre = $conn->prepare($sql_corredores);
$stmt_corre->bindParam(':carrera_id', $carrera_id, PDO::PARAM_INT);
$stmt_corre->execute();
$total_registros = $stmt_corre->rowCount();
$total_paginas = ceil($total_registros / $registros_por_pagina);

$sql_corredores .= " LIMIT $inicio_registro, $registros_por_pagina";



$stmt_corredores = $conn->prepare($sql_corredores);
$stmt_corredores->bindParam(':carrera_id', $carrera_id, PDO::PARAM_INT);
$stmt_corredores->execute();
$corredores = $stmt_corredores->fetchAll(PDO::FETCH_ASSOC);

// Ordenar según la columna seleccionada
$columna = isset($_GET['columna']) ? $_GET['columna'] : 'documento';
$orden = isset($_GET['orden']) && $_GET['orden'] == 'desc' ? 'desc' : 'asc';

usort($corredores, function($a, $b) use ($columna, $orden) {
    if ($a[$columna] == $b[$columna]) {
        return 0;
    }

    if ($orden == 'asc') {
        return $a[$columna] < $b[$columna] ? -1 : 1;
    } else {
        return $a[$columna] > $b[$columna] ? -1 : 1;
    }
});

?>