<?php
// filepath: /c:/xampp/htdocs/licencias/admin/registrar_pago.php


// Conexión a la base de datos
include('db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];


// Verificar el nivel de acceso
if ($nivel_acceso != 2 ) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}

//*

// Obtener el ID del usuario logueado y el ID de la federación desde la sesión
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];


// Comprobamos si se ha enviado un formulario
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Recuperamos los datos enviados desde el formulario
    $id = $_POST['id']; // ID del campeonato
    $nombre = $_POST['campeonato_nombre'];
    $fecha = $_POST['campeonato_fecha'];
    $lugar = $_POST['campeonato_lugar'];
    $activo = $_POST['activo'];

    // Actualizar los datos en la base de datos
    $sql = "UPDATE campeonatos SET campeonato_nombre = :nombre, campeonato_fecha = :fecha, campeonato_lugar = :lugar, activo = :activo WHERE id = :id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
    $stmt->bindParam(':fecha', $fecha, PDO::PARAM_STR);
    $stmt->bindParam(':lugar', $lugar, PDO::PARAM_STR);
    $stmt->bindParam(':activo', $activo, PDO::PARAM_INT);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    if ($stmt->execute()) {
        $_SESSION['success_msg'] = 'Campeonato modificado con éxito';
        header('Location: editar_campeonato.php?id=' . $id);
    } else {
        echo "Hubo un error al guardar los cambios.";
    }
} else {
    // Si el formulario no se ha enviado, obtenemos los datos de la base de datos
    if (isset($_GET['id'])) {
        $id = $_GET['id'];

        // Consulta para obtener los datos del campeonato por el ID
        $sql = "SELECT * FROM campeonatos WHERE id = :id";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $campeonato = $stmt->fetch(PDO::FETCH_ASSOC);
    } else {
        echo "ID no proporcionado.";
    }
}
?>

