document.getElementById('searchForm').addEventListener('submit', function(event) {
    event.preventDefault();
    var documento = document.getElementById('documento').value;
    var carrera_id = document.getElementById('carrera_id').value;

    fetch('config/buscar_corredor_carrera.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body');
        modalBody.innerHTML = '';
        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
            <div class="column-container">
            <div class="column-left">
                <p><strong>Nombre:</strong>${data.Nombre}</p>
                <p><strong>Apellido:</strong> ${data.apellidos}</p>
                <p><strong>Documento:</strong> ${data.documento}</p>
                <p><strong>Federación:</strong> ${data.federacion}</p>
                             <p><strong>Licencia N°:</strong> ${data.licencia}</p>
                <form action="config/registrar_corredor_carrera.php" method="post">
                <input type="hidden" id="documento" name="documento" value="${data.documento}">
                <input type="hidden" id="id" name="id" value="${carrera_id}">
                <input id="enviar" type="submit" value="Cargar a Carrera" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            </form>
            </div>
            <div class="column-right">
            
            <img src="${data.foto}" alt="Foto de perfil" style="width: 200px; height: 200px; border-radius: 50%;" />

            </div>
            </div>

            `;
        }

        document.getElementById('myModal8').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });
});

function closeModal8() {
    document.getElementById('myModal8').style.display = 'none';
}

window.onclick = function(event) {
    if (event.target == document.getElementById('myModal8')) {
        closeModal8();
    }
}

function ordenar(columna) {
    const urlParams = new URLSearchParams(window.location.search);
    const currentOrder = urlParams.get('orden') === 'desc' ? 'asc' : 'desc';
    urlParams.set('columna', columna);
    urlParams.set('orden', currentOrder);
    window.location.search = urlParams.toString();
}


function selectSuggestion1(documento) {
    document.getElementById("documento").value = documento;
    document.getElementById("suggestions").style.display = "none";
    
    var carrera_id = document.getElementById('carrera_id').value;

    fetch('config/buscar_corredor_carrera.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body');
        modalBody.innerHTML = '';

        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
            <div class="column-container">
            <div class="column-left">
                <p><strong>Nombre:</strong>${data.Nombre}</p>
                <p><strong>Apellido:</strong> ${data.apellidos}</p>
                <p><strong>Documento:</strong> ${data.documento}</p>
                <p><strong>Federación:</strong> ${data.federacion}</p>
                <p><strong>Licencia N°:</strong> ${data.licencia}</p>
                <form action="config/registrar_corredor_carrera.php" method="post">
                <input type="hidden" id="documento" name="documento" value="${data.documento}">
                <input type="hidden" id="id" name="id" value="${carrera_id}">
                <input id="enviar" type="submit" value="Cargar a carrera" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            </form>
            </div>
            <div class="column-right">
            
            <img src="${data.foto}" alt="Foto de perfil" style="width: 200px; height: 200px; border-radius: 50%;">

            </div>
            </div>

            `;
        }

        document.getElementById('myModal8').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });


}


function buscarporqr() {
   
    var documento = document.getElementById('documento').value;
    var carrera_id = document.getElementById('carrera_id').value;

    fetch('config/buscar_corredor_carrera.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body');
        modalBody.innerHTML = '';
        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
            <div class="column-container">
            <div class="column-left">
                <p><strong>Nombre:</strong>${data.Nombre}</p>
                <p><strong>Apellido:</strong> ${data.apellidos}</p>
                <p><strong>Documento:</strong> ${data.documento}</p>
                <p><strong>Federación:</strong> ${data.federacion}</p>
                             <p><strong>Licencia N°:</strong> ${data.licencia}</p>
                <form action="config/registrar_corredor_carrera.php" method="post">
                <input type="hidden" id="documento" name="documento" value="${data.documento}">
                <input type="hidden" id="id" name="id" value="${carrera_id}">
                <input id="enviar" type="submit" value="Cargar a Carrera" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            </form>
            </div>
            <div class="column-right">
            
            <img src="${data.foto}" alt="Foto de perfil" style="width: 200px; height: 200px; border-radius: 50%;" />

            </div>
            </div>

            `;
        }

        document.getElementById('myModal8').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });
}

const codeReader = new ZXing.BrowserMultiFormatReader();
const videoElement = document.getElementById('video');
const documentoInput = document.getElementById('documento');
const searchForm = document.getElementById('searchForm');
const beepSound = new Audio('beep.mp3');

document.getElementById('startButton').addEventListener('click', function () {
    codeReader.decodeFromVideoDevice(null, videoElement, (result, error) => {
        if (result) {
            const detectedText = result.getText();
         
            beepSound.play();
            // Extraer la parte antes de la primera coma
            const firstPart = detectedText.split(',')[0];

            // Establecer el valor en el input con id 'documento'
            documentoInput.value = firstPart;

            // Enviar el formulario
            buscarporqr();
        }
        if (error) {
            console.error(error);
        }
    });
});

       
