
<?php
// Datos de conexión a la base de datos
require('db1.php');


// Suponiendo que el 'documento' es enviado desde el frontend, lo capturamos también
$data = json_decode(file_get_contents('php://input'), true);
$email = $data['email'];
$documento1 = $data['documento']; // El valor del 'documento' enviado


try {
    // Establecer la conexión con PDO
  $conn = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8", $db_user, $db_pass);
    // Configurar el manejo de errores
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // Consulta SQL para verificar si el email está asociado al documento
    $sql = "SELECT COUNT(*) FROM users WHERE email = :email AND documento = :documento";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':email', $email, PDO::PARAM_STR);
    $stmt->bindParam(':documento', $documento1, PDO::PARAM_STR); // Usamos PDO::PARAM_STR ya que 'documento' es un texto
    
    // Ejecutar la consulta
    $stmt->execute();
    
    // Obtener el número de registros encontrados
    $result = $stmt->fetchColumn();
    
    if ($result > 0) {
        // Si existe el email con el documento, se permite la carga
        echo json_encode(['exists' => true, 'can_upload' => true]);
    } else {
        // Consultamos si el correo existe en otro documento
        $sql = "SELECT COUNT(*) FROM users WHERE email = :email";
        $stmt = $conn->prepare($sql);
        $stmt->bindParam(':email', $email, PDO::PARAM_STR);
        $stmt->execute();
        
        // Si existe pero no está asociado al documento, mostramos el error
        $emailExists = $stmt->fetchColumn();
        if ($emailExists > 0) {
            echo json_encode(['exists' => true, 'can_upload' => false]); // El correo existe, pero no está asociado al documento
        } else {
            echo json_encode(['exists' => false, 'can_upload' => false]); // El correo no existe
        }
    }
} catch (PDOException $e) {
    // Manejo de errores si la conexión falla
    echo json_encode(['error' => 'Error en la conexión: ' . $e->getMessage()]);
}
?>