<?php
// filepath: /c:/xampp/htdocs/licencias/admin/registrar_pago.php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('db.php');
include('../temp_exportar_empadronado.php');
require 'vendor/autoload.php';  // Asegúrate de que el path al autoload sea correcto

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $carrera_id = $_POST['carrera_id'];
    $federacion_id_user = $_SESSION['usuario_fedid'];

    // Verificar que la carrera sea del usuario
    $stmt_carrera_user = $conn->prepare("SELECT federacion_id from carreras where id = :id_carrera");
    $stmt_carrera_user->bindParam(':id_carrera', $carrera_id, PDO::PARAM_INT);
    $stmt_carrera_user->execute();
    $carrera = $stmt_carrera_user->fetch(PDO::FETCH_ASSOC);

    if ($carrera['federacion_id'] != $federacion_id_user) {
        $_SESSION['error_msg'] = "No puedes registrar un corredor en una carrera de otra federación." . $carrera['federacion_id'] . " - " . $federacion_id_user;
        header('Location: ../editar_carrera.php?id=' . $carrera_id );
        exit();
    }


    // Actualizar la base de datos con la fecha de pago y el código UCI
    $sql = "update carreras set cerrada = 1 where id = :carrera_id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':carrera_id', $carrera_id, PDO::PARAM_INT);

    if ($stmt->execute()) {
        $_SESSION['success_msg'] = "Carrera cerrada.";

//obtener datos
$stmt_carrera1 = $conn->prepare("SELECT * from carreras where id = :id_carrera");
$stmt_carrera1->bindParam(':id_carrera', $carrera_id, PDO::PARAM_INT);
$stmt_carrera1->execute();
$carrera = $stmt_carrera1->fetch(PDO::FETCH_ASSOC);

$stmt_emailadmin = $conn->prepare("SELECT email from usuarios where federacion_id = 1");
$stmt_emailadmin->execute();
$email_admin = $stmt_emailadmin->fetch(PDO::FETCH_ASSOC);
//EMAIL - no te olvides de arriba

try {
    
       // Crear una instancia de PHPMailer
       $mail = new PHPMailer(true); 

       // Configuración del servidor SMTP
   $mail->isSMTP();  // Configurar el correo para usar SMTP
    $mail->Host = 'ci1.toservers.com';  // Servidor SMTP (en este caso Gmail)
    $mail->Username = 'licenciamiento@ciclismoarg.com';
       $mail->Password = 'r3aBxFPf&M26';  // Tu contraseña de Gmail (o usar "contraseñas de aplicaciones" si tienes habilitada la verificación en dos pasos)
       $mail->SMTPSecure = 'ssl'; 
       $mail->SMTPAuth = true;     
       $mail->Port = 465;  //o 465    
       $mail->CharSet = 'UTF-8';
       // Remitente y destinatario
       $mail->setFrom('licenciamiento@ciclismoarg.com', htmlspecialchars('FAC en Pista y Ruta'));
       $mail->addAddress($email_admin['email'], 'Administrador'); // Agregar un destinatario
       $mail->addReplyTo('licenciamiento@ciclismoarg.com', htmlspecialchars('FAC en Pista y Ruta'));  // Responder a este correo (opcional)
       
       expo($carrera_id);

       // Agregar archivo adjunto
     $archivo_temporal = 'empadronados_' . $carrera_id . '.xlsx';


    // Ahora agregamos el archivo como adjunto
    $mail->addAttachment($archivo_temporal, 'empadronados_1.xlsx');  // Ruta del archivo temporal y nombre del archivo adjunto

    // Contenido del correo
    $mail->isHTML(true);  // Establecer el formato de correo a HTML
    $mail->Subject = htmlspecialchars($carrera['federacion_carrera'] . '| Carrera ' . htmlspecialchars($carrera['nombre_carrera']) . " - " . htmlspecialchars($carrera['fecha_carrera']) ." (". $carrera['lugar_carrera'] . ') CERRADA');
    $mail->Body    = '<img src="https://ciclismoarg.com.ar/licencias/logo2.jpeg" alt="Logo" height="150">

    <br style="margin-top:20px">
    <h3>La federación ' . $carrera['federacion_carrera'] . ' ha cerrado la carrera ' . htmlspecialchars($carrera['nombre_carrera']) . ', realizada el ' . htmlspecialchars($carrera['fecha_carrera']) .' en ' . $carrera['lugar_carrera'] . '.</h3>
    <br style="margin-top:20px">
    <p>Adjunto está el listado de corredores.</p>
    <br style="margin-top:20px">

    <img src="https://ciclismoarg.com.ar/licencias/logo2.jpeg" alt="Logo" height="150">
    ';
    $mail->AltBody = strip_tags($mensaje);

    // Enviar el correo
    if ($mail->send()) {
        echo 'El mensaje ha sido enviado con éxito';
    } else {
        echo 'No se pudo enviar el mensaje.';
    }
    unlink($archivo_temporal);
} catch (Exception $e) {
    // Si ocurre algún error
    echo "El mensaje no pudo ser enviado. Error: {$mail->ErrorInfo}";
}



    } else {
        // Obtener información del error
        $errorInfo = $stmt->errorInfo();
        $_SESSION['error_msg'] = "Error al cerrar carrera: " . $errorInfo[2];
    }

    // Redirigir de vuelta a la página de pagos
    header('Location: ../editar_carrera.php?id=' . $carrera_id );
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos
    header('Location: ../editar_carrera.php?id=' . $carrera_id );
    exit();
}
?>