<?php
// filepath: /c:/xampp/htdocs/licencias/admin/registrar_pago.php
session_start();
include('db.php');
if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso <> 2 ) { // Cambia este valor según el nivel de acceso requerido
    header("Location: ../.../index.php");
    exit();
}
// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $carrera_id = $_POST['id'];
    $cerrar = $_POST['cerrar'];

  

    // Actualizar la base de datos con la fecha de pago y el código UCI
    $sql = "update campeonatos set activo = :cerrar where id = :carrera_id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':carrera_id', $carrera_id, PDO::PARAM_INT);
    $stmt->bindParam(':cerrar', $cerrar, PDO::PARAM_INT);


    if ($stmt->execute()) {
        $_SESSION['success_msg'] = "Campeonato modificado.";
    } else {
        // Obtener información del error
        $errorInfo = $stmt->errorInfo();
        $_SESSION['error_msg'] = "Error al intentar: " . $errorInfo[2];
    }

    // Redirigir de vuelta a la página de pagos
    header('Location: ../editar_campeonato.php?id=' . $carrera_id );
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos
    header('Location: ../editar_campeonato.php?id=' . $carrera_id );
    exit();
}
?>