<?php
// Conexión a la base de datos usando PDO
include_once('config/db.php');

// Obtener el ID del usuario logueado y el ID de la federación desde la sesión
$usuario_id = $_SESSION["usuario_id"];
$federacion_id_usuario = $_SESSION["usuario_fedid"];

// Consulta para obtener el nombre de la federación
$sql_federacion = "SELECT federacion FROM federaciones WHERE id = :federacion_id_usuario";
$stmt = $conn->prepare($sql_federacion);
$stmt->bindParam(':federacion_id_usuario', $federacion_id_usuario, PDO::PARAM_INT);
$stmt->execute();
$federacion_usuario = $stmt->fetch(PDO::FETCH_ASSOC)['federacion'];


$stmt_opseguros = $conn->prepare("SELECT DISTINCT opseguro FROM users");
$stmt_opseguros->execute();
$opseguros = $stmt_opseguros->fetchAll(PDO::FETCH_ASSOC);

// Manejo de búsqueda
$campeonato = isset($_GET['campeonato']) ? trim($_GET['campeonato']) : ''
;
// Configuración de paginación
$registros_por_pagina = 20;
$pagina_actual = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$inicio_registro = ($pagina_actual - 1) * $registros_por_pagina;

// Construcción de la consulta
$sql = "SELECT * FROM campeonatos where 1 = 1";
$params = [];


// Agregar filtro por documento si corresponde
if ($campeonato !== '') {
    $sql .= " and campeonato_nombre LIKE :campeonato order by campeonato_fecha desc";
    $params[':campeonato'] = "%$campeonato%";
} else {
    $sql .= " order by campeonato_fecha desc";
}



// Ejecutar la consulta para obtener el número total de registros
$stmt = $conn->prepare($sql);
$stmt->execute($params);
$total_registros = $stmt->rowCount();

// Calcular total de páginas
$total_paginas = ceil($total_registros / $registros_por_pagina);

// Agregar límite para la paginación
$sql .= " LIMIT $inicio_registro, $registros_por_pagina";

// Ejecutar consulta con paginación
$stmt = $conn->prepare($sql);
$stmt->execute($params);
$registros = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>
