<?php


ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include('db.php');


// Obtener categorías desde la tabla categorias0
$sql_categorias = "SELECT DISTINCT categoria FROM users WHERE lic = 'Activa' ORDER BY categoria ASC";
$stmt = $conn->prepare($sql_categorias);
$stmt->execute();
$categorias = $stmt->fetchAll(PDO::FETCH_ASSOC);


// Verificar si los datos del formulario fueron enviados
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['id_campeonato']) && isset($_POST['categorias'])) {
    $id_campeonato = $_POST['id_campeonato'];
    $categorias_seleccionadas = $_POST['categorias'];
    
    // Validar que el id_campeonato es válido
    if (empty($id_campeonato) || !is_numeric($id_campeonato)) {
        die("ID de campeonato no válido.");
    }

    // Insertar las categorías seleccionadas en la tabla campeonato_cat
    try {
        // Eliminar las categorías existentes asociadas a este campeonato antes de insertar nuevas
        $stmt = $conn->prepare("DELETE FROM campeonato_cat WHERE id_campeonato = :id_campeonato");
        $stmt->bindParam(':id_campeonato', $id_campeonato, PDO::PARAM_INT);
        $stmt->execute();

        // Preparar la consulta de inserción
        $stmt = $conn->prepare("INSERT INTO campeonato_cat (id_campeonato, categoria) VALUES (:id_campeonato, :id_categoria)");

        // Iniciar la transacción
        $conn->beginTransaction();

        // Ejecutar la inserción para cada categoría seleccionada
        foreach ($categorias_seleccionadas as $id_categoria) {
            // Validar que la categoría sea un valor numérico
     

            $stmt->bindParam(':id_campeonato', $id_campeonato, PDO::PARAM_INT);
            $stmt->bindParam(':id_categoria', $id_categoria, PDO::PARAM_STR);
            $stmt->execute();
        }

        // Confirmar la transacción
        $conn->commit();
        
        // Redirigir con un mensaje de éxito
        $_SESSION['success_msg'] = "Categorías añadidas al campeonato correctamente.";
        header("Location: ../editar_campeonato.php?id=" . $id_campeonato);
        exit();

    } catch (PDOException $e) {
        // Si ocurre un error, revertir la transacción
        $conn->rollBack();
        $_SESSION['error_msg'] = "Error al agregar categorías: " . $e->getMessage();
        header("Location: ../editar_campeonato.php?id=" . $id_campeonato);
        exit();
    }
}
?>
