        function showSuggestions1(str) {
            if (str.length == 0) {
                document.getElementById("suggestions").innerHTML = "";
                document.getElementById("suggestions").style.display = "none";
                return;
            }
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    document.getElementById("suggestions").innerHTML = this.responseText;
                    document.getElementById("suggestions").style.display = "block";
                }
            };
            xmlhttp.open("GET", "get_suggestions1.php?q=" + str, true);
            xmlhttp.send();
        }
        
        
                function selectSuggestion1(documento) {
            document.getElementById("documento").value = documento;
            document.getElementById("suggestions").style.display = "none";
            document.getElementById("searchForm").submit();
        }


document.addEventListener('DOMContentLoaded', function() {
    var menuToggle = document.getElementById('menu-toggle');
    var menu = document.getElementById('menu');

    menuToggle.addEventListener('click', function() {
        menu.classList.toggle('show');
    });
});


document.querySelectorAll('.clickable-row').forEach(function(row) {
    row.addEventListener('click', function() {
        this.classList.toggle('active');
    });
});









document.getElementById('searchForm').addEventListener('submit', function(event) {
    event.preventDefault();
    var documento = document.getElementById('documento').value;
    var carrera_id = document.getElementById('carrera_id').value;

    fetch('config/buscar_corredor_campeonato.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento) + '&carrera_id=' + encodeURIComponent(carrera_id)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body');
        modalBody.innerHTML = '';
        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
            <div class="column-container">
    <div class="column-left">
        <img src="${data.foto}" alt="Foto de perfil" style="width: 200px; height: 200px; border-radius: 50%;" />
        <p><strong>Nombre:</strong>${data.Nombre}</p>
        <p><strong>Apellido:</strong> ${data.apellidos}</p>
        <p><strong>Documento:</strong> ${data.documento}</p>
        <p><strong>Federación:</strong> ${data.federacion}</p>

        
    </div>
    <div class="column-right">
    <label for="pruebas">Inscribirse a las sig. pruebas:</label>
    <form id="formulario" action="config/registrar_corredor_campeonato.php" method="post">
        <input type="hidden" id="documento" name="documento" value="${data.documento}">
        <input type="hidden" id="id" name="id" value="${carrera_id}">
        <div id="pruebas" name="pruebas[]">
            ${data.pruebas.map(prueba => `
                <div class="prueba-container">
                    <label class="prueba-label" for="prueba-${prueba.id}">${prueba.nombre_prueba}</label>
                    <input class="prueba-checkbox" type="checkbox" id="prueba-${prueba.id}" name="pruebas[]" value="${prueba.id}">
                </div>
            `).join('')}
        </div>
        <input id="enviar" type="submit" value="Empadronar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
    </form>
</div>
</div>

            `;
        }

        document.getElementById('myModal8').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });
});


function closeModal8() {
    document.getElementById('myModal8').style.display = 'none';
}

window.onclick = function(event) {
    if (event.target == document.getElementById('myModal8')) {
        closeModal8();
    }
}

function ordenar(columna) {
    const urlParams = new URLSearchParams(window.location.search);
    const currentOrder = urlParams.get('orden') === 'desc' ? 'asc' : 'desc';
    urlParams.set('columna', columna);
    urlParams.set('orden', currentOrder);
    window.location.search = urlParams.toString();
}


function selectSuggestion1(documento) {
    document.getElementById("documento").value = documento;
    document.getElementById("suggestions").style.display = "none";
    
    var carrera_id = document.getElementById('carrera_id').value;


    fetch('config/buscar_corredor_campeonato.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento) + '&carrera_id=' + encodeURIComponent(carrera_id)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body');
        modalBody.innerHTML = '';

        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
            <div class="column-container">
    <div class="column-left">
        <img src="${data.foto}" alt="Foto de perfil" style="width: 200px; height: 200px; border-radius: 50%;"/>
        <p><strong>Nombre:</strong>${data.Nombre}</p>
        <p><strong>Apellido:</strong> ${data.apellidos}</p>
        <p><strong>Documento:</strong> ${data.documento}</p>
        <p><strong>Federación:</strong> ${data.federacion}</p>

        
    </div>
    <div class="column-right">
    <label for="pruebas">Inscribirse a las sig. pruebas:</label>
    <form id="formulario" action="config/registrar_corredor_campeonato.php" method="post">
        <input type="hidden" id="documento" name="documento" value="${data.documento}">
        <input type="hidden" id="id" name="id" value="${carrera_id}">
        <div id="pruebas" name="pruebas[]">
            ${data.pruebas.map(prueba => `
                <div class="prueba-container">
                    <label class="prueba-label" for="prueba-${prueba.id}">${prueba.nombre_prueba}</label>
                    <input class="prueba-checkbox" type="checkbox" id="prueba-${prueba.id}" name="pruebas[]" value="${prueba.id}">
                </div>
            `).join('')}
        </div>
        <input id="enviar" type="submit" value="Empadronar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
    </form>
</div>
</div>

            `;
        }

        document.getElementById('myModal8').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });


}
      



function eliminarinscripcion() {
    const filas = document.querySelectorAll('#tabla tbody tr');

    // Agregar un evento de clic a cada fila
    filas.forEach(fila => {
        fila.addEventListener('click', () => {
            // Obtener el valor de la columna 'documento' de la fila seleccionada
            const documento = fila.querySelector('.documento').textContent;
            var carrera_id = document.getElementById('carrera_id').value;

            fetch('config/buscar_corredor_campeonato.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: 'documento=' + encodeURIComponent(documento) + '&carrera_id=' + encodeURIComponent(carrera_id)
            })
            .then(response => response.json())
            .then(data => {
                var modalBody = document.getElementById('modal-body1');
                modalBody.innerHTML = '';

                if (data.error) {
                    modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
                } else {
                    // Crear la tabla con las carreras dentro de las pruebas
                    let tablaCarreras = '<table style="width: 100%; margin-top: 20px;margin-bottom;20px">';
                    tablaCarreras += `
                        <thead>
                            <tr>
                                <th>Inscripto en pruebas:</th>
                            </tr>
                        </thead>
                        <tbody>
                    `;
                    // Iterar sobre las pruebas (carreras) para generar las filas
                    data.pruebas_reg.forEach(prueba => {
                        tablaCarreras += `
                            <tr>
                                <td data-label="Prueba">${prueba.nombre_prueba}</td>
                            </tr>
                        `;
                    });

                    tablaCarreras += '</tbody></table>';

                    // Insertar la tabla en el modal
                    modalBody.innerHTML = `
                        <div class="column-total">
                            <p><strong>Nombre:</strong>${data.Nombre}</p>
                            <p><strong>Apellido:</strong> ${data.apellidos}</p>
                            <p><strong>Documento:</strong> ${data.documento}</p>
                            <p><strong>Federación:</strong> ${data.federacion}</p>

                            ${tablaCarreras} <!-- Aquí se inserta la tabla -->

                            <form action="config/eliminar_corredor_campeonato.php" method="post">
                                <input type="hidden" id="documento" name="documento" value="${data.documento}">
                                <input type="hidden" id="id" name="id" value="${carrera_id}">
                                <input id="enviar" type="submit" value="Eliminar Inscripción" style="padding: 10px 20px; border: none; border-radius: 4px; background-color:rgb(170, 89, 89); color: #fff; cursor: pointer; margin-left: 10px;">
                            </form>
                        </div>
                    `;
                }

                // Mostrar el modal
                document.getElementById('myModal9').style.display = 'block';
            })
            .catch(error => {
                console.error('Error:', error);
            });
        });
    });

}


function closeModal9() {
    document.getElementById('myModal9').style.display = 'none';
}

window.onclick = function(event) {
    if (event.target == document.getElementById('myModal9')) {
        closeModal9();
    }
}