<?php
// filepath: /c:/xampp/htdocs/licencias/admin/config/buscar_corredor_carrera.php
session_start();

require 'db.php'; // Conexión a la base de datos

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $documento = trim($_POST['documento']);
    $foto = '../../fotos/' .$documento. '.png';
        
    if(!file_exists($foto)){
        $fotoPath = "../sinfoto.png";
    } else {
        $fotoPath = $foto;
    }
}



header('Content-Type: application/json'); // Asegúrate de que la respuesta sea JSON

try {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $documento = trim($_POST['documento']);
        // Sanitize the user input to prevent path traversal
        if (!empty($documento)) {
            $sql = "SELECT * FROM users WHERE documento = :documento AND lic = 'Suspendida' ";
            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':documento', $documento, PDO::PARAM_STR);
            $stmt->execute();
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            $foto = 'fotos/' .$documento. '.png';

            if ($user) {
                // Verificar si la foto existe

                    $user['foto'] = $fotoPath;
                

                // Insertar el campo carrera_id

                echo json_encode($user);
            } else {
                echo json_encode(['error' => 'No se encontró ningún usuario con ese documento.']);
            }
        } else {
            echo json_encode(['error' => 'El campo de documento o carrera_id está vacío.']);
        }
    } else {
        echo json_encode(['error' => 'Método de solicitud no válido.']);
    }
} catch (Exception $e) {
    echo json_encode(['error' => 'Error del servidor: ' . $e->getMessage()]);
}
?>