<?php
// filepath: /c:/xampp/htdocs/licencias/admin/config/buscar_corredor_carrera.php
session_start();

require 'db.php'; // Conexión a la base de datos

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $documento = trim($_POST['documento']);
    $foto = '../../fotos/' .$documento. '.png';
        
    if(!file_exists($foto)){
        $fotoPath = "../sinfoto.png";
    } else {
        $fotoPath = 'https://ciclismoarg.com/licencias/fotos/'.$documento. '.png' ;
    }
}



header('Content-Type: application/json'); // Asegúrate de que la respuesta sea JSON

try {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $documento = trim($_POST['documento']);

        // Sanitize the user input to prevent path traversal
        if (!empty($documento)) {
            $sql = "SELECT * FROM users WHERE documento = :documento AND lic = 'Activa' ";
            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':documento', $documento, PDO::PARAM_STR);
            $stmt->execute();
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            $foto = 'fotos/' .$documento. '.png';
            $genero = $user['genero'];

                // Obtener las pruebas disponibles para el campeonato
                    $stmt_pruebas = $conn->prepare("SELECT p.id, p.nombre_prueba, p.genero FROM pruebas_campeonatos p WHERE p.id_campeonato = :campeonato_id and p.genero = :genero");
                    $stmt_pruebas->bindParam(':campeonato_id', $_POST['carrera_id'], PDO::PARAM_INT);
                    $stmt_pruebas->bindParam(':genero', $genero, PDO::PARAM_STR);
                    $stmt_pruebas->execute();
                    $pruebas = $stmt_pruebas->fetchAll(PDO::FETCH_ASSOC);                
                    
                    
                    // Obtener las pruebas actuales del corredor
                    $stmt_pruebas_cor = $conn->prepare("SELECT p.id, p.nombre_prueba FROM pruebas_campeonatos p join campeonatos_registros cr on p.id = cr.id_prueba WHERE p.id_campeonato = :campeonato_id and cr.corredor_documento = :documento");
                    $stmt_pruebas_cor->bindParam(':campeonato_id', $_POST['carrera_id'], PDO::PARAM_INT);
                    $stmt_pruebas_cor->bindParam(':documento', $documento, PDO::PARAM_STR);
                    $stmt_pruebas_cor->execute();
                    $pruebas_reg = $stmt_pruebas_cor->fetchAll(PDO::FETCH_ASSOC);


             $user['pruebas'] = $pruebas;
             $user['pruebas_reg'] = $pruebas_reg;  

            if ($user) {
                // Verificar si la foto existe

                    $user['foto'] = $fotoPath;
                

                // Insertar el campo carrera_id

                echo json_encode($user);
            } else {
                echo json_encode(['error' => 'No se encontró ningún usuario con ese documento.']);
            }
        } else {
            echo json_encode(['error' => 'El campo de documento o carrera_id está vacío.']);
        }
    } else {
        echo json_encode(['error' => 'Método de solicitud no válido.']);
    }
} catch (Exception $e) {
    echo json_encode(['error' => 'Error del servidor: ' . $e->getMessage()]);
}
?>