<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('db.php');


// Verificar si se ha enviado el formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos del formulario
    $documento = $_POST['documento'];
    $fecha_desde = $_POST['fecha_desde'];
    $fecha_hasta = $_POST['fecha_hasta'];
    $acta = $_POST['detalle'];



    // Verificar que los datos no estén vacíos
    if (empty($fecha_desde) || empty($documento) || empty($fecha_hasta)) {
        $_SESSION['error_msg'] = "Todos los campos son obligatorios.";
        header('Location: ../autorizaciones.php' );
        exit();
    }

   


    // Actualizar 
    $sql2 = "INSERT INTO autorizaciones SET documento = :documento, detalle = :acta, fecha_desde = :fecha_desde, fecha_hasta = :fecha_hasta, adjunto = :adjunto";
    $stmt2 = $conn->prepare($sql2);
    $lastInsertId = trim(date('Ymdhhmmss'));
    $newFileName = $lastInsertId . $documento . '.pdf';
    $uploadFileDir1 = 'autorizaciones/';
    $dest_path1 = $uploadFileDir1 . $newFileName;

    $stmt2->bindParam(':acta', $acta, PDO::PARAM_STR);
    $stmt2->bindParam(':fecha_desde', $fecha_desde, PDO::PARAM_STR);
    $stmt2->bindParam(':fecha_hasta', $fecha_hasta, PDO::PARAM_STR);
    $stmt2->bindParam(':documento', $documento, PDO::PARAM_STR);
    $stmt2->bindParam(':adjunto', $dest_path1, PDO::PARAM_STR);

    $success2 = $stmt2->execute();

    if ($success2) {
        $_SESSION['success_msg'] = "DNI $documento autorizado.";
       } else {
        // Obtener información del error
        $errorInfo2 = $stmt2->errorInfo();
        $_SESSION['error_msg'] = "Error al registrar la suspensión " . $errorInfo2[2];
    }

    if (isset($_FILES['adjunto']) && $_FILES['adjunto']['error'] === UPLOAD_ERR_OK) {
        // Obtener información del archivo subido
        $fileTmpPath = $_FILES['adjunto']['tmp_name'];
        $fileName = $_FILES['adjunto']['name'];
        $fileSize = $_FILES['adjunto']['size'];
        $fileType = $_FILES['adjunto']['type'];
        $fileNameCmps = explode(".", $fileName);
        $fileExtension = strtolower(end($fileNameCmps));

        // Establecer el nombre del archivo como documento.png
        $newFileName = $lastInsertId . $documento . '.pdf';

        // Establecer la ruta de destino
        $uploadFileDir = '../autorizaciones/';
        $dest_path = $uploadFileDir . $newFileName;

        // Mover el archivo subido a la ubicación de destino
        if(move_uploaded_file($fileTmpPath, $dest_path)) {
           $_SESSION['success_msg'] = "El archivo se ha subido correctamente.";
        } else {
            $_SESSION['error_msg'] =  "Hubo un error al mover el archivo subido.";
        }
    } else {
        echo "ALGUN ERROR";
    }

    // Redirigir de vuelta a la página de pagos masivos
    header('Location: ../autorizaciones.php' );
    exit();
} else {
    // Si no se ha enviado el formulario, redirigir a la página de pagos masivos
    header('Location: ../autorizaciones.php' );
    exit();
}


?>