document.getElementById('searchForm').addEventListener('submit', function(event) {
    event.preventDefault();
    var documento = document.getElementById('documento').value;

    fetch('config/buscar_corredor_carrera.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body');
        modalBody.innerHTML = '';
        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
         <div class="column-container">
            <div class="column-left">
                <p><strong>Nombre:</strong>${data.Nombre}</p>
                <p><strong>Apellido:</strong> ${data.apellidos}</p>
                <p><strong>Documento:</strong> ${data.documento}</p>
                <p><strong>Email:</strong> ${data.email}</p>
                <p><strong>Federación:</strong> ${data.federacion}</p>
                
            </div>
            <div class="column-right">
            
           <form action="config/autorizar_corredor.php" method="post" enctype="multipart/form-data">
                <input type="hidden" id="documento" name="documento" value="${data.documento}">
                <label> Fecha desde</label>
                <input type="date" id="fecha_desde" name="fecha_desde" requeried>
                <label> Fecha hasta</label>
                <input type="date" id="fecha_hasta" name="fecha_hasta" requeried>
                <label>Detalle</label>
                <input type="text" id="detalle" name="detalle" requeried>
                <label>PDF</label>
                <input type="file" id="adjunto" name="adjunto" accept="pdf/*">
                <input id="enviar" type="submit" value="Cargar Autorización" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            

            
            </form>

            </div>
            </div>

            `;
        }

        document.getElementById('myModal8').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });
});

function closeModal8() {
    document.getElementById('myModal8').style.display = 'none';
}

window.onclick = function(event) {
    if (event.target == document.getElementById('myModal8')) {
        closeModal8();
    }
}

function ordenar(columna) {
    const urlParams = new URLSearchParams(window.location.search);
    const currentOrder = urlParams.get('orden') === 'desc' ? 'asc' : 'desc';
    urlParams.set('columna', columna);
    urlParams.set('orden', currentOrder);
    window.location.search = urlParams.toString();
}


function selectSuggestion1(documento) {
    document.getElementById("documento").value = documento;
    document.getElementById("suggestions").style.display = "none";
    


    fetch('config/buscar_corredor_carrera.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body');
        modalBody.innerHTML = '';

        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
        <div class="column-container">
            <div class="column-left">
                <p><strong>Nombre:</strong>${data.Nombre}</p>
                <p><strong>Apellido:</strong> ${data.apellidos}</p>
                <p><strong>Documento:</strong> ${data.documento}</p>
                <p><strong>Email:</strong> ${data.email}</p>
                <p><strong>Federación:</strong> ${data.federacion}</p>
                
            </div>
            <div class="column-right">
            
           <form action="config/autorizar_corredor.php" method="post" enctype="multipart/form-data">
                <input type="hidden" id="documento" name="documento" value="${data.documento}">
                <label> Fecha desde</label>
                <input type="date" id="fecha_desde" name="fecha_desde" requeried>
                <label> Fecha hasta</label>
                <input type="date" id="fecha_hasta" name="fecha_hasta" requeried>
                <label>Detalle</label>
                <input type="text" id="detalle" name="detalle" requeried>
                <label>PDF</label>
                <input type="file" id="adjunto" name="adjunto" accept="pdf/*">
                <input id="enviar" type="submit" value="Cargar Autorización" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            

            
            </form>

            </div>
            </div>

            `;
        }

        document.getElementById('myModal8').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });


}
       
function filterTable() {
    var checkbox = document.getElementById('filterSuspendido');
    var rows = document.querySelectorAll('#tabla tbody tr');
    rows.forEach(function(row) {
        var estado = row.cells[6].innerText;
        if (checkbox.checked) {
            if (estado !== 'Suspendido') {
                row.style.display = '';
            } else {
                row.style.display = '';
        } }else {if (estado == 'Suspendido') {
            row.style.display = '';
            row.style.background = '#f2d7d5';

        }else {
                row.style.display = 'none';
            }}
        
    });}



function autorizacion() {

    const filas = document.querySelectorAll('#tabla tbody tr');

    // Agregar un evento de clic a cada fila
    filas.forEach(fila => {
        fila.addEventListener('click', () => {
            // Obtener el valor de la columna 'documento' de la fila seleccionada
            const documento = fila.querySelector('.documento').textContent;
            const id = fila.querySelector('.id').textContent;
            // Mostrar el valor en el párrafo con id 'resultado'
          


    fetch('config/buscar_corredor_autorizado.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'documento=' + encodeURIComponent(documento)
    })
    .then(response => response.json())
    .then(data => {
        var modalBody = document.getElementById('modal-body1');
        modalBody.innerHTML = '';

        if (data.error) {
            modalBody.innerHTML = '<p style="color: red;">' + data.error + '</p>';
        } else {
            modalBody.innerHTML = `
                    <div class="column-container">
            <div class="column-left">
                <p><strong>Nombre:</strong>${data.Nombre}</p>
                <p><strong>Apellido:</strong> ${data.apellidos}</p>
                <p><strong>Documento:</strong> ${data.documento}</p>
                <p><strong>Federación:</strong> ${data.federacion}</p>
            </div>
            <div class="column-right">
                <p><strong>Fecha desde:</strong> ${data.fecha_desde}</p>
                <p><strong>Fecha hasta:</strong> ${data.fecha_hasta}</p>
                <p><strong>Detalle:</strong> ${data.detalle}</p>
                <p><strong>Adjunto:</strong> <a style="color: black;margin:3px" href="${data.adjunto}"><i style="color: black;margin:5px" class="fa-solid fa-cloud-arrow-down fa-lg"></i></a></p>

                <form action="config/eliminar_autorizacion.php" method="post">
                <input type="hidden" id="documento" name="documento" value="${data.documento}">
                <input type="hidden" id="id" name="id" value="${id}">
                <input id="enviar" type="submit" value="Eliminar Autorización" style="padding: 10px 20px; border: none; border-radius: 4px; background-color:rgb(59, 141, 127); color: #fff; cursor: pointer; margin-left: 10px;">
            </form>
            </div>
</div>
            `;
        }

        document.getElementById('myModal9').style.display = 'block';
    })
    .catch(error => {
        console.error('Error:', error);
    });

});
});

}


function closeModal9() {
    document.getElementById('myModal9').style.display = 'none';
}

window.onclick = function(event) {
    if (event.target == document.getElementById('myModal9')) {
        closeModal9();
    }
}


function searchTable() {
    const input = document.getElementById("searchInput");
    const filter = input.value.toLowerCase();  // Convertimos el texto a minúsculas para hacer la búsqueda insensible al caso
    const table = document.getElementById("tabla");
    const rows = table.getElementsByTagName("tr"); // Obtenemos todas las filas de la tabla

    // Iteramos sobre las filas (excepto la cabecera)
    for (let i = 1; i < rows.length; i++) {
        const cells = rows[i].getElementsByTagName("td");
        let rowContainsSearchTerm = false; // Indicador de si alguna celda coincide con la búsqueda

        // Iteramos sobre cada celda de la fila
        for (let j = 0; j < cells.length; j++) {
            const cell = cells[j];
            if (cell.textContent.toLowerCase().includes(filter)) {
                rowContainsSearchTerm = true; // Si la celda contiene el término de búsqueda, marcamos la fila como coincidente
                break;
            }
        }

        // Mostramos u ocultamos la fila según si contiene el término de búsqueda
        if (rowContainsSearchTerm) {
            rows[i].style.display = "";
        } else {
            rows[i].style.display = "none";
        }
    }
}


