<?php
session_start();

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('db.php');

$hoy = date('Y-m-d');

// Suspender licencias de programadas
$stmt = $conn->prepare("
    SELECT u.documento, u.Nombre, u.apellidos, u.categoria, u.suspendido, u.federacion, s.fecha_desde, s.fecha_hasta 
    FROM users u 
    JOIN suspensiones s ON u.documento = s.documento 
    WHERE s.fecha_desde <= :hoy AND s.fecha_hasta >= :hoy and u.suspendido = 0
");
$stmt->bindParam(':hoy', $hoy, PDO::PARAM_STR);
$stmt->execute();

// Verificar si hay registros
if ($stmt->rowCount() > 0) {
    // Obtener los resultados como un array asociativo
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Extraer los documentos usando array_column() sobre el array de resultados
    $documentos = array_column($resultados, 'documento');
    
    // Convertir el array de documentos a una cadena separada por comas para usar en la consulta IN
    $documentos_str = implode(',', array_map('intval', $documentos));

    // Actualizar la columna 'suspendido' a 1 para los documentos encontrados
    $update_stmt = $conn->prepare("
        UPDATE users 
        SET suspendido = 1, lic = 'Suspendida'
        WHERE documento IN ($documentos_str)
    ");
    
    $update_stmt->execute();

    echo "Los documentos sig documentos se han suspendido:<br>";
    foreach ($documentos as $documento) {
        echo $documento . "<br>";
    }
} else {
    echo "No se encontraron documentos para suspender.";
}

// Activar licencias de suspensiones terminadas
$stmt1 = $conn->prepare("
    SELECT u.documento, u.Nombre, u.apellidos, u.categoria, u.suspendido, u.federacion, s.fecha_desde, s.fecha_hasta 
    FROM users u 
    JOIN suspensiones s ON u.documento = s.documento 
    WHERE s.fecha_hasta <= :hoy and u.suspendido = 1
");
$stmt1->bindParam(':hoy', $hoy, PDO::PARAM_STR);
$stmt1->execute();

// Verificar si hay registros
if ($stmt1->rowCount() > 0) {
    // Obtener los resultados como un array asociativo
    $resultados1 = $stmt1->fetchAll(PDO::FETCH_ASSOC);

    // Extraer los documentos usando array_column() sobre el array de resultados
    $documentos1 = array_column($resultados1, 'documento');
    
    // Convertir el array de documentos a una cadena separada por comas para usar en la consulta IN
    $documentos_str1 = implode(',', array_map('intval', $documentos1));

    // Actualizar la columna 'suspendido' a 0 para los documentos encontrados
    $update_stmt1 = $conn->prepare("
        UPDATE users 
        SET suspendido = 0, lic = 'Activa'
        WHERE documento IN ($documentos_str1)
    ");
    
    $update_stmt1->execute();

    echo "Los documentos han sido reactivados:<br>";
    foreach ($documentos1 as $documento1) {
        echo $documento1 . "<br>";
    }
    echo "No se encontraron documentos para reactivar.";
}
?>
