<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];


// Verificar el nivel de acceso
if ($nivel_acceso < 0) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}

include('config/carreras_data.php');
include('header.php');

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Bienvenido</title>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>
    <link rel="stylesheet" type="text/css" href="stylespagos.css?id=14234">
  
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=12434">
    <link rel="stylesheet" type="text/css" href="styles.css?id=12434">



           <script src="config/scripts.js?id=32234" defer></script>
<style>
    tr, th {
        text-align: left;
    }
    @media (max-width: 768px) {
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }
    .contenedor {
        margin: 20 20 0 20;
        padding: 10px;
        width: auto;
    }

}
    </style>
</head>
<body>

    <main class="contenedor">
    <div >
        <h2 id="titulo" >Mis Carreras</h2>
        <?php if (isset($_SESSION['success_msg'])): ?>
            <p style="color: green;"><?php echo htmlspecialchars($_SESSION['success_msg']); ?></p>
            <?php unset($_SESSION['success_msg']); ?>
        <?php endif; ?>

        <?php if (isset($_SESSION['error_msg'])): ?>
            <p style="color: red;"><?php echo htmlspecialchars($_SESSION['error_msg']); ?></p>
            <?php unset($_SESSION['error_msg']); ?>
        <?php endif; ?>
        <form id="searchForm" action="" method="get" style="position: relative; display: inline-block; margin-bottom: 20px;">
            <input type="text" id="carreraa" name="carrera" value="<?php echo htmlspecialchars($carrera); ?>" onkeyup="showSuggestions(this.value)" placeholder="Buscar por nombre" autocomplete="off" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
            <input type="submit" value="Buscar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            <div id="suggestions" style="display: none;"></div>
        </form>
        <div class="export">
        <a class="export" href="#" onclick="openModal4()" class="button">Nueva Carrera</a>
        </div>
       
        <table id="federadosTable">
            <thead>
            <tr>
                <th>Carrera</th>
                <th>Fecha</th>
                <th>Federación</th>
                <th>Inscripciones</th>
                <th>Acción</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($registros as $fila): ?>
                <tr style="<?php if(($fila["cerrada"]==0)): ?>background-color:#a0cb9e94<?php else:?>background-color:#f2d7d5<?php endif;?>" class="clickable-row">
                <td data-label="Carrera"><?php echo htmlspecialchars($fila["nombre_carrera"]); ?></td>
                <td data-label="Fecha"><?php echo htmlspecialchars($fila["fecha_carrera"]); ?></td>
                <td data-label="Federación"><?php echo htmlspecialchars($fila["federacion_carrera"]); ?></td>
                <?php if(($fila["cerrada"]==0)): ?>
                <td data-label="Estado">
                Inscrp. Abiertas
            </td>
            <?php else: ?>
                <td data-label="Estado">
                Inscrip. Cerradas
                </td>
            <?php endif; ?>
                <td data-label="Acción"><a href="editar_carrera.php?id=<?php echo htmlspecialchars($fila["id"]); ?>" class="button">Editar</a></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>

        <div class="pagination">
        <?php if ($pagina_actual > 1): ?>
                <a href="carreras.php?page=<?php echo $pagina_actual - 1; ?>">&laquo;</a>
            <?php endif; ?>
            <?php for ($i = max(1, $pagina_actual - 2); $i <= min($total_paginas, $pagina_actual + 2); $i++): ?>
                <a href="carreras.php?page=<?php echo $i; ?>" class="<?php echo $i == $pagina_actual ? 'active' : ''; ?>">
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>
            <?php if ($pagina_actual < $total_paginas): ?>
                <a href="carreras.php?page=<?php echo $pagina_actual + 1; ?>">&raquo;</a>
            <?php endif; ?>
        </div>
            </div>
    </main>

    <div id="myModal4" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal4()">&times;</span>
            <h2 style="margin-bottom:20px">Nueva Carrera</h2>
            <form id="pagoForm" action="config/nueva_carrera.php" method="POST">
                <input type="hidden" id="federacion_id" name="federacion_id" value="<?php echo htmlspecialchars($federacion_id_usuario); ?>">
                <div>
                <input type="text" id="nombre_carrera" name="nombre_carrera" placeholder="Nombre de la carrera" required>
                <input type="date" id="fecha_carrera" name="fecha_carrera" required>
                <input type="text" id="federacion_carrera" name="federacion_carrera" placeholder="Federación" value="<?php echo htmlspecialchars($federacion_usuario); ?>" readonly>
                <input type="text" id="lugar_carrera" name="lugar_carrera" placeholder="Lugar Carrera" required>

                </div>
                <button type="submit" class="button" >Guardar Carrera</button>
            </form>
        </div>
    </div>



    <script>
        function exportTableToExcel(tableID, filename = ''){
            var downloadLink;
            var dataType = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
            var tableSelect = document.getElementById(tableID);
            var tableHTML = tableSelect.outerHTML.replace(/ /g, '%20');
            
            // Create a Blob from the table HTML
            var blob = new Blob([tableHTML], { type: dataType });

            // Create a link element
            downloadLink = document.createElement("a");

            // Set the link's href to a URL created from the Blob
            downloadLink.href = URL.createObjectURL(blob);

            // Set the download attribute with a filename
            downloadLink.download = filename ? filename + '.xls' : 'excel_data.xls';

            // Append the link to the body
            document.body.appendChild(downloadLink);

            // Click the link to trigger the download
            downloadLink.click();

            // Remove the link from the document
            document.body.removeChild(downloadLink);
        }
    </script>
</body>
</html>
