<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];


// Verificar el nivel de acceso
if ($nivel_acceso < 0) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}

include('config/campeonatos_data.php');
include('header.php');

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Bienvenido</title>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>
    <link rel="stylesheet" type="text/css" href="stylespagos.css?id=14234">
 
    <link rel="stylesheet" type="text/css" href="stylesform.css?id=1223434">
    <link rel="stylesheet" type="text/css" href="styles.css?id=13234">


           <script src="config/scripts.js?id=32234" defer></script>
           <style>
            
    tr, th {
        text-align: left;
    }
    @media (max-width: 768px) {
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }
    .contenedor {
        margin: 20 20 0 20;
        padding: 10px;
        width: auto;
    }
    #federadosTable > tbody > tr > td.botontabla > a:nth-child(2) {
        margin: 0px !important;
        width: 100px;
    }
    #federadosTable > tbody > tr > td.botontabla > a:nth-child(1){
        margin: 20px 0px 10px 0px;
        width: 100px;
    }
    }
    </style>
</head>
<body>

    <main class="contenedor">
        <h2 id="titulo" >Campeonatos</h2>
        <?php if (isset($_SESSION['success_msg'])): ?>
            <p style="color: green;"><?php echo htmlspecialchars($_SESSION['success_msg']); ?></p>
            <?php unset($_SESSION['success_msg']); ?>
        <?php endif; ?>

        <?php if (isset($_SESSION['error_msg'])): ?>
            <p style="color: red;"><?php echo htmlspecialchars($_SESSION['error_msg']); ?></p>
            <?php unset($_SESSION['error_msg']); ?>
        <?php endif; ?>
        <form id="searchForm" action="" method="get" style="position: relative; display: inline-block; margin-bottom: 20px;">
            <input type="text" id="campeonato" name="campeonato" value="" onkeyup="showSuggestions(this.value)" placeholder="Buscar por nombre" autocomplete="off" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
            <input type="submit" value="Buscar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            <div id="suggestions" style="display: none;"></div>
        </form>
        <?php if($nivel_acceso == 2): ?>
        <div class="export">
        <a class="export" href="#" onclick="openModal4()" class="button">Nuevo campeonato</a>
        </div>
        <?php endif; ?>
        <table id="federadosTable">
            <thead>
            <tr>
                <th>Campeonato</th>
                <th>Fecha</th>
                <th>Lugar</th>
                <?php if($nivel_acceso == 2): ?>
                <th style="text-align:center">Editar</th>
                <?php else: ?>
                <?php endif; ?>
                <th style="text-align:center">Inscripciones</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($registros as $fila): ?>
                <tr class="clickable-row">
                <td data-label="Campeonato"><?php echo htmlspecialchars($fila["campeonato_nombre"]); ?></td>
                <td data-label="Fecha"><?php echo htmlspecialchars($fila["campeonato_fecha"]); ?></td>
                <td data-label="Lugar"><?php echo htmlspecialchars($fila["campeonato_lugar"]); ?></td>
                <?php if($fila['activo'] == 1): ?>
                    <?php if($nivel_acceso == 2): ?>
                    <td data-label="" style="justify-content: center;" class="botontabla"><a href="editar_campeonato.php?id=<?php echo htmlspecialchars($fila["id"]); ?>" class="button">Editar</a></td>
                    <td style="text-align: center;"><a style="background-color: green" href="ver_campeonato.php?id=<?php echo htmlspecialchars($fila["id"]); ?>" class="button">Inscripciones ABIERTAS</a></td>
                    <?php else: ?>
                    <td data-label="" style="justify-content: center;" class="botontabla"><a style="background-color: green" href="ver_campeonato.php?id=<?php echo htmlspecialchars($fila["id"]); ?>" class="button">Inscripciones ABIERTAS</a></td>
                    <?php endif; ?>
                    <?php else: ?>
                    <?php if($nivel_acceso == 2): ?>
                    <td data-label="" class="botontabla" style="justify-content: center;"><a href="editar_campeonato.php?id=<?php echo htmlspecialchars($fila["id"]); ?>" class="button">Editar</a>
                    </td>
                    <td style="text-align: center;"><a style="background-color:grey;text-align:center" href="ver_campeonato.php?id=<?php echo htmlspecialchars($fila["id"]); ?>" class="button">Inscriptos</a>
                    </td>
                    <?php else: ?>
                    <td data-label="" class="botontabla" style="justify-content: center;"><a style="" href="ver_campeonato.php?id=<?php echo htmlspecialchars($fila["id"]); ?>" class="button">Mis inscriptos</a></td>
                    <?php endif; ?>
                <?php endif; ?>    
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>

        <div class="pagination">
            <?php if ($pagina_actual > 1): ?>
                <a href="campeonatos.php?page=<?php echo $pagina_actual - 1; ?>">&laquo;</a>
            <?php endif; ?>
            <?php for ($i = max(1, $pagina_actual - 2); $i <= min($total_paginas, $pagina_actual + 2); $i++): ?>
                <a href="campeonatos.php?page=<?php echo $i; ?>" class="<?php echo $i == $pagina_actual ? 'active' : ''; ?>">
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>
            <?php if ($pagina_actual < $total_paginas): ?>
                <a href="campeonatos.php?page=<?php echo $pagina_actual + 1; ?>">&raquo;</a>
            <?php endif; ?>
        </div>
    </main>

    <div id="myModal4" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal4()">&times;</span>
            <h2 style="margin-bottom:20px">Nuevo Campeonato</h2>
            <form id="pagoForm" action="config/nuevo_campeonato.php" method="POST">
                <div>
                <input type="text" id="campeonato_nombre" name="campeonato_nombre" placeholder="Nombre del campeonato" required>
                <input type="date" id="campeonato_fecha" name="campeonato_fecha" required>
                <input type="text" id="campeonato_lugar" name="campeonato_lugar" placeholder="Lugar Campeonato" required>
                </div>
                <button type="submit" class="button" >Guardar</button>
            </form>
        </div>
    </div>



    <script>
        function exportTableToExcel(tableID, filename = ''){
            var downloadLink;
            var dataType = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
            var tableSelect = document.getElementById(tableID);
            var tableHTML = tableSelect.outerHTML.replace(/ /g, '%20');
            
            // Create a Blob from the table HTML
            var blob = new Blob([tableHTML], { type: dataType });

            // Create a link element
            downloadLink = document.createElement("a");

            // Set the link's href to a URL created from the Blob
            downloadLink.href = URL.createObjectURL(blob);

            // Set the download attribute with a filename
            downloadLink.download = filename ? filename + '.xls' : 'excel_data.xls';

            // Append the link to the body
            document.body.appendChild(downloadLink);

            // Click the link to trigger the download
            downloadLink.click();

            // Remove the link from the document
            document.body.removeChild(downloadLink);
        }
    </script>
</body>
</html>
