<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');
include('config/bienvenida_data.php');


// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso <> 2) { // Cambia este valor según el nivel de acceso requerido
    echo "No tienes permiso para acceder a esta página.";
    exit();
}

include('header.php');
$mensaje = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nuevo_licenciaanio = trim($_POST['licenciaanio']);

    // Crear la tabla users_aniosanteriores si no existe
    $stmt = $conn->prepare("
        CREATE TABLE IF NOT EXISTS users_aniosanteriores AS 
        SELECT *, NOW() AS fecha_copia FROM users WHERE 1=0
    ");
    $stmt->execute();

    // Copiar los datos actuales de la tabla users a users_aniosanteriores con una marca temporal
    $stmt = $conn->prepare("
        INSERT INTO users_aniosanteriores 
        SELECT *, NOW() AS fecha_copia FROM users
    ");
    $stmt->execute();

    // Actualizar el valor de licenciaanio en la tabla anios
    $stmt = $conn->prepare("UPDATE anios SET licenciaanio = :licenciaanio");
    $stmt->bindParam(':licenciaanio', $nuevo_licenciaanio, PDO::PARAM_INT);
    $stmt->execute();

    $nueva_vigencia = ('31/12/' . htmlspecialchars($nuevo_licenciaanio));
    // Actualizar los registros en la tabla users
    $stmt = $conn->prepare("UPDATE users SET fecha_pago = null, fecha_seguro = null, fecha_registro = null, fecha_federado = null, licenciaanio = NULL, federacion = NULL, federado = 0, suspendido = 0, lic = 'Pendiente de registro', LicValida = :vigencia, licencia = null ");
    $stmt->bindParam(':vigencia', $nueva_vigencia, PDO::PARAM_STR);
    $stmt->execute();

    $mensaje = 'Cambios guardados exitosamente.';
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Cambiar Licencia Año</title>
    <link rel="stylesheet" type="text/css" href="styles.css?id=1233">
    <script src="config/scripts.js" defer></script>
</head>
<body>

    <main>
        <h3>Cambiar Licencia Año</h3>

        <?php if ($mensaje): ?>
            <p id="estado"><?php echo $mensaje; ?></p>
        <?php endif; ?>
        <?php if (!$mensaje): ?>
        <form action="" method="post" style="position: relative; display: inline-block; margin-bottom: 20px;">
        <p>ATENCIÓN: al cambiar el año, copiará los licenciados del año anterior y eliminará todos los registros para su reinscripción.</p>
   
        <label for="licenciaanio">Nuevo Año de licencias:</label>
            <input type="text" id="licenciaanio" name="licenciaanio" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);" pattern="^\d{4}$" placeholder="Sólo ingresar 4 números" required>
            <input type="submit" value="Guardar Cambios" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
        </form>
        <?php endif; ?>
    </main>
</body>
</html>