<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once('config/db.php');

// Obtener el nivel de acceso del usuario
include('../header_home.php');
include('buscar_autorizaciones_data.php');
$hoy = strtotime(date('Y-m-d'));

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Bienvenido</title>
    <script src="https://kit.fontawesome.com/ad1090de93.js" crossorigin="anonymous"></script>
    <link href="https://fonts.googleapis.com/css2?family=Raleway:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="styles.css?id=1234">
  
    <style>
          @media (max-width: 768px) {
    td {
        text-align: left;
        padding-left: 45%;
        position: relative;
        font-size: 14px;
        min-height: 20px;
    }


}
        </style>

</head>
<body>

    <main class="contenedor">
        <h2 id="titulo">Buscar Autorizaciones <br> Corredores Argentinos</h2>

        <form id="searchForm" action="" method="post" style="position: relative; display: inline-block; margin-bottom: 20px;">
            <input type="text" id="documento" name="documento" value="" placeholder="Buscar por documento" autocomplete="off" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
            <input type="submit" value="Buscar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            <div id="suggestions" style="display: none;"></div>
        </form>
        <?php if (!empty($_POST['documento'])): ?>
        <?php if (empty($corredores)): ?>
            <br>
            No se encontraron autorizaciones para el DNI <?php echo htmlspecialchars($_POST['documento']); ?>
        <?php elseif (!empty($corredores)): ?>
                <table id="">
                        <thead>
                            <tr>
                                <th class="<?php echo $columna == 'documento' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('documento')" >DNI</th>
                                <th class="<?php echo $columna == 'Nombre' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('Nombre')" >Nombre</th>
                                <th class="<?php echo $columna == 'apellidos' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('apellidos')" >Apellidos</th>
                                <th class="<?php echo $columna == 'federacion' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('federacion')" >Federación</th>
                                <th>Detalle</th>
                                <th class="<?php echo $columna == 'fecha_desde' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('fecha_desde')" >Fecha Desde</th>
                                <th class="<?php echo $columna == 'fecha_hasta' ? 'sorted-' . $orden : ''; ?>" onclick="ordenar('fecha_hasta')" >Fecha Hasta</th>
                                <th>Estado</th>
                                <th >Adjunto</th>
                            </tr>
                        <thead>
                        <tbody>
                            <?php foreach ($corredores as $corredor): ?>
                                <?php 
                                $estado_suspension = ( strtotime($corredor['fecha_hasta']) >= $hoy) ? 'Vigente' : 'Vencida';
                                ?>
                                <tr  style="background-color:<?php if($estado_suspension == 'Vencida'):?>#f2d7d5<?php else:?>#a0cb9e94<?php endif; ?>" class="clickable-row">
                                    <td data-label="Documento"class="documento"><?php echo htmlspecialchars($corredor['documento']); ?></td>
                                    <td class="id" style="display:none"><?php echo htmlspecialchars($corredor['id']); ?></td>
                                    <td data-label="Nombre"><?php echo htmlspecialchars($corredor['Nombre']); ?></td>
                                    <td data-label="Apellido"><?php echo htmlspecialchars($corredor['apellidos']); ?></td>
                                    <td data-label="Federación"><?php echo htmlspecialchars($corredor['federacion']); ?></td>                  
                                    <td data-label="Detalle"><?php echo htmlspecialchars($corredor['detalle']); ?></td>
        
                                    <td data-label="Fecha Desde"><?php echo htmlspecialchars($corredor['fecha_desde']); ?></td>
                                    <td data-label="Fecha Hasta"><?php echo htmlspecialchars($corredor['fecha_hasta']); ?></td>
                                    <td data-label="Estado"><?php echo htmlspecialchars($estado_suspension); ?></td>
                                    <td><a class="button" style="color: black;margin:3px" href="<?php echo htmlspecialchars($corredor['adjunto']); ?>">Descargar</a></td> 
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
           <?php endif; ?>                     
           <?php endif; ?>                     
        </div>
    </main>
</body>
</html>
