<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION["usuario"])) {
    header("Location: index.php");
    exit();
}

// Conexión a la base de datos
include('config/db.php');

// Obtener el nivel de acceso del usuario
$usuario_id = $_SESSION["usuario_id"];
$stmt = $conn->prepare("SELECT nivel_acceso FROM usuarios WHERE usuario_id = :usuario_id");
$stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
$stmt->execute();
$nivel_acceso = $stmt->fetch(PDO::FETCH_ASSOC)['nivel_acceso'];

// Verificar el nivel de acceso
if ($nivel_acceso < 0) { // Cambia este valor según el nivel de acceso requerido
    header("Location: index.php");
    exit();
}

include('config/bienvenida_data.php');
include('header.php');

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Bienvenido</title>
    <script src="config/scripts.js" defer></script>
    <script src="https://kit.fontawesome.com/ad1090de93.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" type="text/css" href="styles.css?id=1435">
    
<style>
tr, th {
    text-align: left;
}
</style>

</head>
<body>

    <main>
        <h2 id="titulo" >Federados del año </h2>

        <form id="searchForm" action="" method="get" style="position: relative; display: inline-block; margin-bottom: 20px;">
            <input type="text" id="documento" name="documento" value="<?php echo htmlspecialchars($documento); ?>" onkeyup="showSuggestions(this.value)" placeholder="Buscar por documento" autocomplete="off" style="padding: 10px; border: 1px solid #ccc; border-radius: 4px; width: 200px; box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);">
            <input type="submit" value="Buscar" style="padding: 10px 20px; border: none; border-radius: 4px; background-color: #2e86c1; color: #fff; cursor: pointer; margin-left: 10px;">
            <div id="suggestions" style="display: none;"></div>
        </form>

        <div class="export">
        <a class="export" href="federados.php" class="button">Ver todos</a>
        <a class="export" href="exportar_federados.php" class="button">Exportar a Excel</i></a>
        </div>
        <table id="federadosTable">
            <thead>
            <tr>
                <th>Apellido</th>
                <th>Nombre</th>
                <th>Documento</th>
                <th>Op. Seguro</th>
                <th>UCI</th>
                <th>Licencia</th>
                <th>Federación</th>
                <th>Categoría</th>
                <th>Estado licencia</th>
                <th style="text-align:center" >Acción</th>
            </tr>
            <thead>
                <tbody>
            <?php foreach ($registros as $fila): ?>
            <tr class="clickable-row">
            <td data-label="Apellido"><?php echo htmlspecialchars($fila["apellidos"]); ?></td>
            <td data-label="Nombre"><?php echo htmlspecialchars($fila["Nombre"]); ?></td>
            <td id="mas" data-label=""><i class="fa-solid fa-square-plus"></i></td>
            <td data-label="" class="extra flecha"><i class="fa-solid fa-square-minus fa-lg"></i></td>
            <td data-label="Documento" class="extra"><?php echo htmlspecialchars($fila["documento"]); ?></td>
            <td data-label="Op. Seguro" class="extra"><?php echo htmlspecialchars($fila["opseguro"]); ?></td>
            <td data-label="UCI" class="extra"><?php echo htmlspecialchars($fila["uci"] ?? ''); ?></td>
            <td data-label="Licencia" class="extra"><?php echo htmlspecialchars($fila["licencia"]); ?></td>
            <td data-label="Federación" class="extra"><?php echo htmlspecialchars($fila["federacion"]); ?></td>
            <td data-label="Categoría" class="extra"><?php echo htmlspecialchars($fila["categoria"]); ?></td>
            <td data-label="Estado licencia" class="extra"><?php echo htmlspecialchars($fila["lic"]); ?></td>
<?php if ($nivel_acceso == 2): ?>
                    <td style="text-align:center"  class="botontabla extra"><a href="editar_registro_master.php?documento=<?php echo htmlspecialchars($fila["documento"]); ?>" class="button">Editar</a></td>
<?php else: ?>
    <td style="text-align:center" class="extra"><a href="editar_registro.php?documento=<?php echo htmlspecialchars($fila["documento"]); ?>" class="button">Editar</a></td>
<?php endif; ?>
                </tr>
            <?php endforeach; ?>
</tbody>
        </table>

        <div class="pagination">
            <?php if ($pagina_actual > 1): ?>
                <a href="bienvenida.php?page=<?php echo $pagina_actual - 1; ?>&documento=<?php echo htmlspecialchars($documento); ?>">&laquo;</a>
            <?php endif; ?>
            <?php for ($i = max(1, $pagina_actual - 2); $i <= min($total_paginas, $pagina_actual + 2); $i++): ?>
                <a href="bienvenida.php?page=<?php echo $i; ?>&documento=<?php echo htmlspecialchars($documento); ?>" class="<?php echo $i == $pagina_actual ? 'active' : ''; ?>">
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>
            <?php if ($pagina_actual < $total_paginas): ?>
                <a href="bienvenida.php?page=<?php echo $pagina_actual + 1; ?>&documento=<?php echo htmlspecialchars($documento); ?>">&raquo;</a>
            <?php endif; ?>
        </div>
    </main>
    <script>
        function exportTableToExcel(tableID, filename = ''){
            var downloadLink;
            var dataType = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
            var tableSelect = document.getElementById(tableID);
            var tableHTML = tableSelect.outerHTML.replace(/ /g, '%20');
            
            // Create a Blob from the table HTML
            var blob = new Blob([tableHTML], { type: dataType });

            // Create a link element
            downloadLink = document.createElement("a");

            // Set the link's href to a URL created from the Blob
            downloadLink.href = URL.createObjectURL(blob);

            // Set the download attribute with a filename
            downloadLink.download = filename ? filename + '.xls' : 'excel_data.xls';

            // Append the link to the body
            document.body.appendChild(downloadLink);

            // Click the link to trigger the download
            downloadLink.click();

            // Remove the link from the document
            document.body.removeChild(downloadLink);
        }
    </script>
</body>
</html>
